/*=========================================================================

  Program:   ORFEO Toolbox
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


  Copyright (c) Centre National d'Etudes Spatiales. All rights reserved.
  See OTBCopyright.txt for details.

  Copyright (c) Institut Telecom; Telecom Bretagne. All rights reserved.
  See ITCopyright.txt for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#include <iostream>
#include <cstdlib>

#include "otbVectorImage.h"
#include "otbBoxAndWhiskerImageFilter.h"

int otbBoxAndWhiskerImageFilterNew(int argc, char * argv[])
{
  const unsigned int Dimension = 2;
  typedef double                                   PixelType;
  typedef otb::VectorImage<PixelType, Dimension>   ImageType;
  typedef otb::BoxAndWhiskerImageFilter<ImageType> FilterType;

  FilterType::Pointer filter = FilterType::New();

  std::cout << filter << std::endl;

  return EXIT_SUCCESS;
}
