Minutes from 63rd OpenVDB TSC meeting, Sep 1st, 2020, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Andre Pradhana (DW), Ahmed Mahmoud

Regrets: *Peter* C.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) 7.2
5) NanoVDB
6) GCC 9.1 (PR 769)
7) CpuTimer using C++11 chrono (PR 690)
8) Introducing a "feature/abi8" branch (related to PR 788)
9) Deprecating code (PR 806, StringGrid, Tree::prune(), LeafNode::str(), etc)
10) "Locking down the grid configuration"
11) Extrapolate SOP
12) Next Meeting


1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) Forum

Ken to reply to post about large VDBs/OOC. Dan to reply to delayed-loading
post.

There was a question about static libraries on Windows. Include paths need to
be included as a system header using MSVC. Including VDB headers is generating
warnings that are suppressed when building the core library. Nick has replied
to this qs.

4) 7.2

Nick has merged the PRs that removed the Makefiles and restructured the
codebase. Planning on introducing the first PR that brings AX into the master
branch, initially the core AX library only, then the Houdini SOP subsequently.

5) NanoVDB

NanoVDB probably aiming for an 8.0 integration to allow a little more time for
the codebase to mature. Ken currently merging NanoVDB up to the feature branch
on a weekly cadence.

New work includes a tool for recomputing the grid statistics, foreach, range
and invoke wrappers around TBB functionality. Current effort is in adding
DirectX support, seems this will be relatively trivial.

Some users are asking for documentation around the memory layout. Investigation
ongoing to look at replacing Jeff's work with the C library with a more
automated approach. Jeff notes that initial compile time is a bit of a problem
when using JIT.

Matt Pharr has incorporated NanoVDB into PBRT with pleasing results.

6) GCC 9.1 (PR 769)

Addressed concerns Jeff raised with bool specialization for higher-order
intepolation schemes by tackling the problem at the source. PR is now ready to
be merged.

7) CpuTimer using C++11 chrono (PR 690)

Dan investigated thread-safety issues with C++11 chrono. Adopted similar
solution to that favored by TBB which is to store the number of microseconds
since epoch instead of the time_point struct. This allows for starting and
stopping a CpuTimer across multiple threads. PR is now ready to be merged.

8) Introducing a "feature/abi8" branch (related to PR 788)

Need somewhere to put ABI=8 development in the run-up to 8.0.0. Solution
preferred by all is to use the master branch instead of introducing a new
feature branch that needs to be kept in sync. This will be gated by a standard
ABI=8 macro but with an additional EXPERIMENTAL flag to reduce chance it will
be picked up by accident, similar to the DEPRECATED flag.

9) Deprecating code (PR 806, StringGrid, Tree::prune(), LeafNode::str(), etc)

When should we deprecate? Is one minor version sufficient? Consensus that we
should be a bit more aggressive with deprecations, users often ignore
deprecation warnings anyway. Still nice to give users as much warning as
possible. New major version is a good time to drop API support and force
users to change their code. We should consider introducing a 7.1.1 patch
version with deprecation warnings. All to review the CSG operation PR 785.

Can we drop support for duplicateSourceStealable()? Nick still using it
heavily. Limitations with current SOP implementation that causes issues with
time dependency. Solution is to migrate to DS, but big sweep required to do so.
Agreement that we should remove these methods anyway, Jeff/SideFX keen for
people to not use this technique now.

10) "Locking down the grid configuration"

Dan has implemented explicit template instantiation for the tree hierarchy. It
speeds up building unit tests by around 30%, but building the core library now
slower. It works by suppressing implicit template instantiation whenever tree
hierarchy headers are included and explicitly instantiating them once in a
source file compiled with the core library. Unfortunately had to be implemented
using C preprocessor. More discussion needed, implementation shared as draft
PR 813.

11) Extrapolate SOP

Andre reports an issue with an assert firing in the fast sweeping code when run
in debug mode, despite it working correctly in release mode. Assert in question
validates that array indices are non-negative. Andre to share an example with
Dan to investigate the root cause.

12) Next Meeting

Skipping next week. September 15th, 2020. 1pm-2pm EDT (GMT-4).
