# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-722-1 (sudo)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63414);
 script_cve_id("CVE-2009-0034");
 script_version ("$");
 name["english"] = "Ubuntu USN-722-1 (sudo)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to sudo
announced via advisory USN-722-1.

Details follow:

Harald Koenig discovered that sudo did not correctly handle certain
privilege changes when handling groups.  If a local attacker belonged
to a group included in a RunAs list in the /etc/sudoers file, that
user could gain root privileges.  This was not an issue for the default
sudoers file shipped with Ubuntu.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  sudo                            1.6.9p10-1ubuntu3.4

Ubuntu 8.10:
  sudo                            1.6.9p17-1ubuntu2.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-722-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-722-1 (sudo)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.9p10-1ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.9p10-1ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo", ver:"1.6.9p17-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo-ldap", ver:"1.6.9p17-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
