###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ziproxy_server_detect.nasl 754 2009-03-25 15:10:24Z mar $
#
# Ziproxy Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900522);
  script_version("Revision: 1.0 ");
  script_name(english:"Ziproxy Server Version Detection");
  desc["english"] = "
  Overview: This script detects the installed version of Ziproxy Server
  and sets the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets the KB for the version of Ziproxy Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

zipPort = get_http_port(default:8080);
if(!zipPort){
  zipPort = 8080;
}

if(get_port_state(zipPort))
{
  sndReq = string("GET / \r\n\r\n");
  rcvRes = http_keepalive_send_recv(port:zipPort, data:sndReq);
  if("Server: ziproxy" >< rcvRes)
  {
    # Grep the Ziproxy Server Version from response
    ziproxyVer = eregmatch(pattern:"ziproxy/([0-9.]+)", string:rcvRes);

    if(ziproxyVer[1] != NULL){
      set_kb_item(name:"www/" + zipPort + "/Ziproxy", value:ziproxyVer[1]);
    }
  }
}
