###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_simple_machines_forum_sql_inj_vuln.nasl 1876 2009-04-28 17:25:12Z apr $
#
# Simple Machines Forum SQL Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900544);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6741");
  script_bugtraq_id(29734);
  script_name(english:"Simple Machines Forum SQL Injection Vulnerability");
  desc["english"] = "

  Overview: The host is installed with Simple Machines Forum and is prone
  to SQL Injection Vulnerability.

  Vulnerability Insight:
  Error exists while sending an specially crafted SQL statements into load.php
  when setting the db_character_set parameter to a multibyte character which
  causes the addslashes PHP function to generate a \(backslash) sequence that
  does not quote the '(single quote) character, as demonstrated via a manlabels
  action to index.php.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary code,
  and can view, add, modify or delete information in the back-end database.

  Impact Level: System/Application.

  Affected Software/OS:
  Simple Machines Forum 1.1.4 and prior

  Fix: No solution or patch is available as on 29th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.simplemachines.org/

  References:
  http://www.milw0rm.com/exploits/5826
  http://xforce.iss.net/xforce/xfdb/43118

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Simple Machines Forum");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_simple_machines_forum_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpPort = get_http_port(default:80);
if(!httpPort){
  exit(0);
}

if(!get_port_state(httpPort)){
  exit(0);
}

ver = get_kb_item("www/" + httpPort + "/SMF");
ver = eregmatch(pattern:"^(.+) under (/.*)$", string:ver);
if(ver[1] == NULL){
  exit(0);
}

if(version_is_less_equal(version:ver[1], test_version:"1.1.4")){
 security_hole(httpPort);
}
