###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_servu_ftp_server_mult_vuln.nasl 1063 2009-03-23 15:12:29Z mar $
#
# Rhinosoft Serv-U FTP Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900483);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0967", "CVE-2009-1031");
  script_bugtraq_id(34127, 34125);
  script_name(english:"Rhinosoft Serv-U FTP Multiple Vulnerabilities");
  desc["english"] = "

  Overview: This host is running Serv-U FTP Server and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Error when processing 'MKD' commands which can be exploited to create
    directories residing outside a given user's home directory via directory
    traversal attacks.
  - Error when handing certain FTP commands, by sending a large number of
    'SMNT' commands without an argument causes the application to stop
    responding.

  Impact:
  Successful exploitation will let the attacker conduct directory traversal
  attack or can cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Rhinosoft Serv-U FTP Server version 7.4.0.1 or prior.

  Fix: No solution or patch is available as on 25th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.serv-u.com

  References:
  http://www.milw0rm.com/exploits/8211
  http://www.milw0rm.com/exploits/8212
  http://xforce.iss.net/xforce/xfdb/49260
  http://www.vupen.com/english/advisories/2009/0738

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:L/Au:NR/C:N/I:C/A:P)
    CVSS Temporal Score : 7.6
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Serv-U FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_servu_ftp_server_detect.nasl");
  script_require_keys("Serv-U/FTPServ/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  exit(0);
}

banner = get_ftp_banner(port:ftpPort);
if("Serv-U FTP Server" >!< banner){
  exit(0);
}

servuVer = get_kb_item("Serv-U/FTPServ/Ver");
if(!servuVer){
  exit(0);
}

# Check for version 7.4.0.1 and prior
if(version_is_less_equal(version:servuVer, test_version:"7.4.0.1")){
  security_hole(ftpPort);
}
