##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_nuke_detect.nasl 1867 2009-04-27 09:05:29Z apr $
#
# PHP-Nuke Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900338);
  script_version("$Revision: 1.1 $");
  script_name(english:"PHP-Nuke Version Detection");
  desc["english"] = "

  Overview: This script detects the installed PHP-Nuke version and sets
  the result in KB.

  Risk factor:Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the Version of PHP-Nuke");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

nukePort = get_http_port(default:80);
if(!nukePort){
  exit(0);
}

foreach dir (make_list("/php-nuke", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:nukePort);
  rcvRes = http_send_recv(port:nukePort, data:sndReq);
  if(rcvRes == NULL)
  {
    sndReq = http_get(item:string(dir, "/admin.php"), port:nukePort);
    rcvRes = http_keepalive_send_recv(port:nukePort, data:sndReq);
    if(rcvRes == NULL){
      exit(0);
    }
  }

  if("PHP-Nuke" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    foreach path (make_list("/../Changes.txt", "/Changes.txt", "/CHANGES",
                            "/../CHANGES", cgi_dirs()))
    {
      sndReq = http_get(item:string(dir, path), port:nukePort);
      rcvRes = http_keepalive_send_recv(port:nukePort, data:sndReq);

      if("PHP-Nuke" >< rcvRes && "Version" >< rcvRes)
      {
        nukeVer = eregmatch(pattern:"Version ([0-9.]+)", string:rcvRes);
        if(nukeVer[1]!= NULL)
        {
          set_kb_item(name:"www/"+ nukePort + "/php-nuke", value:nukeVer[1] +
                           " under " + dir);
          exit(0);
        }
      }
    }
  }
}
