###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openssl_ca_cert_sec_bypass_vuln.nasl 1061 2009-02-25 12:10:29Z feb $
#
# OpenSSL CA Certificate Security Bypass Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900464);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0653");
  script_name(english:"OpenSSL CA Certificate Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host is running OpenSSL and is prone to Security Bypass
  Vulnerability.

  Vulnerability Insight:
  OpenSSL fails to verify the Basic Constraints for an intermediate CA-signed
  certificate.

  Impact:
  Successful exploitation will let the attacker spoof the SSL cerficate and
  gain sensitive information of the remote user through inserting a malicious
  URL in the contenxt of the openssl certificate.

  Affected Software/OS:
  OpenSSL version 0.9.6 or prior.

  Fix: No solution or Patch is available as on 27th February 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://www.openssl.org/news

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2009-0653

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_openssl_detect_lin.nasl");
  script_require_keys("OpenSSL/Linux/Ver");
  exit(0);
}


include ("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Linux/Ver");
if(opensslVer != NULL)
{
  # Grep for OpenSSL version 0.9.6 or prior.
  if(version_is_less_equal(version:opensslVer, test_version:"0.9.6")){
    security_hole(0);
  }
}
