##############################################################################
#
#  MS Office Products Version Detection
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: Detect script for word, excel and access.
#  Issue #0021
#
#  Retrieving Version from file (Removed old method and updated with GetVer).
#   -By Chandan S 10:46:00 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900032);
  script_version("$Revision: 1.0 $");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_name(english:"MS Office Products Version Detection");
  script_summary(english:"Determines the version of WinWord, Excel, and Access");
  desc["english"] = "
  Overview : Retrieve the version of MS Office products from file and
  sets KB.

  Risk factor : Informational";
  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl", "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!get_kb_item("MS/Office/Ver")){
  exit(0);
}

wordFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\App Paths\Winword.exe", item:"Path");
if(wordFile)
{
  wordFile += "\winword.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wordFile);
  word =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:wordFile);
  wordVer = GetVer(file:word, share:share);
  if(wordVer){
    set_kb_item(name:"SMB/Office/Word/Version", value:wordVer);
  }	
}

excelFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\App Paths\Excel.exe", item:"Path");
if(excelFile)
{
  excelFile += "\excel.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:excelFile);
  excel =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:excelFile);
  excelVer = GetVer(file:excel, share:share);
  if(excelVer){
    set_kb_item(name:"SMB/Office/Excel/Version", value:excelVer);
  }
}

accessFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\MSACCESS.exe", item:"Path");
if(accessFile)
{
  accessFile += "\msaccess.exe";
  share  = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:accessFile);
  access =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:accessFile);
  accessVer = GetVer(file:access, share:share);
  if(accessVer){
    set_kb_item(name:"SMB/Office/Access/Version", value:accessVer);
  }
}

powerpointFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                     "\App Paths\PowerPnt.exe", item:"Path");
if(powerpointFile)
{
  powerpointFile+= "\powerpnt.exe";
  share  = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:powerpointFile);
  power =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:powerpointFile);
  powerPptVer = GetVer(file:power, share:share);
  if(powerPptVer){
    set_kb_item(name:"SMB/Office/PowerPnt/Version", value:powerPptVer);
 }
}
