###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_info_dis_vuln.nasl 875 2009-01-21 18:12:29Z jan $
#
# Microsoft Internet Explorer Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900192);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5912");
  script_bugtraq_id(33276);
  script_name(english:"Microsoft Internet Explorer Information Disclosure Vulnerability");
  desc["english"] = "

  Overview: This host is installed with Internet Explorer and is prone to
  Information Disclosure vulnerability.

  Vulnerability Insight:
  An unspecified function in the JavaScript implementation in Microsoft
  Internet Explorer creates and exposes temporary footprint when there is a
  current login to a web site, which makes it easier for remote attackers
  to trick a user into acting upon a spoofed pop-up message.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary codes
  in the context of the web browser and can reveal sensitive information of
  the remote user through the web browser.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 8 Beta2 and prior on Windows.

  Fix: No solution or patch is available as on 22nd January 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://www.trusteer.com/files/In-session-phishing-advisory-2.pdf
  http://www.darkreading.com/security/attacks/showArticle.jhtml?articleID=212900161

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

if(version_is_less_equal(version:ieVer, test_version:"8.0.6001.18241")){
  security_hole(0);
}
