##############################################################################
#
#  Microsoft Office Information Disclosure Vulnerability (957699)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: schandan
#  Issue #0322
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900047);
  script_bugtraq_id(31693);
  script_cve_id("CVE-2008-4020");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"Microsoft Office nformation Disclosure Vulnerability (957699)");
  script_summary(english:"Check for Microsoft Office file version");
  desc["english"] = "
  MS08-055

  Overview: This host is missing critical security update according to
  Microsoft Bulletin MS08-056.

  Vulnerability Insight:
  The flaw exists due to the way that Office processes documents using the CDO
  Protocol (cdo:) and the Content-Disposition Attachment header.

  Impact: Successful exploitation could allow documents incorrectly rendered
  in the web browser, leading to cross site scripting attack.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Office XP Service Pack 3 on Windows (All).

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-056.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-056.mspx

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.2
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencies("secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

offVer = get_kb_item("MS/Office/Ver");
if(!offVer){
 exit(0);
}

if(offVer =~ "^10\.")
{
  if(registry_key_exists(key:"SOFTWARE\Classes\PROTOCOLS\Handler\cdo") &&
     registry_key_exists(key:"SOFTWARE\Classes\CDO")){
    security_warning(0);
  }
}
