###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mini_stream_prdts_detect.nasl 1826 2009-04-21 17:02:29Z apr $
#
# Mini-Stream Products Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900624);
  script_version ("$Revision: 1.1 $");
  script_name(english:"Mini-Stream Products Version Detection");
  desc["english"] = "
  Overview: The script will detect the Mini-Stream products installed on
  this host and set the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Get the version of the Mini-Stream Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

item1 = "Shadow Stream Recorder_is1\";
ssRecName = registry_get_sz(key:key+item1, item:"DisplayName");
ssRVer = eregmatch(pattern:"Recorder ([0-9.]+)", string:ssRecName);

if(ssRVer[1]!=NULL)
{
  # set the version of Mini-stream Shadow Stream Recorder
  set_kb_item(name:"MiniStream/SSRecorder/Ver", value:ssRVer[1]);
}

item2 = "Mini-stream RM-MP3 Converter_is1\";
rmTmp = registry_get_sz(key:key+item2, item:"DisplayName");
rmTmpVer = eregmatch(pattern:"Converter ([0-9]\.[0-9]\.[0-9.]+)", string:rmTmp);

if(rmTmpVer[1]!=NULL)
{
  #set the version of Mini-stream RM-MP3 Converter
  set_kb_item(name:"MiniStream/RmToMp3/Conv/Ver", value:rmTmpVer[1]);
}

item3 = "WM Downloader_is1\";
wmDown = registry_get_sz(key:key+item3, item:"DisplayName");
wmDownVer = eregmatch(pattern:"Converter ([0-9.]+)", string:wmDown);

if(wmDownVer[1]!=NULL)
{
  #set the version of Mini-stream WM Downloader
  set_kb_item(name:"MiniStream/WMDown/Ver", value:wmDownVer[1]);
}

item4 = "RM Downloader_is1\";
rmDown = registry_get_sz(key:key+item4, item:"DisplayName");
rmDownVer = eregmatch(pattern:" Downloader ([0-9.]+)", string:rmDown);

if(rmDownVer[1]!=NULL)
{
  #set the version of Mini-stream RM Downloader
  set_kb_item(name:"MiniStream/RMDown/Ver", value:rmDownVer[1]);
}

item5 = "ASX to MP3 Converter_is1\";
asx2mpName= registry_get_sz(key:key+item5, item:"DisplayName");
asx2mpVer = eregmatch(pattern:"Converter ([0-9]\.[0-9]\.[0-9.]+)", string:asx2mpName);

if(asx2mpVer[1]!=NULL)
{
  #set the version of Mini-stream ASX to MP3 Converter
  set_kb_item(name:"MiniStream/AsxToMp3/Conv/Ver", value:asx2mpVer[1]);
}

item6 = "Mini-stream Ripper_is1\";
msRipper = registry_get_sz(key:key+item6, item:"DisplayName");
msRipperVer = eregmatch(pattern:"Ripper ([0-9.]+)", string:msRipper);

if(msRipperVer[1]!=NULL)
{
  #set the version of Mini-stream Ripper
  set_kb_item(name:"MiniStream/Ripper/Ver", value:msRipperVer[1]);
}


item7 = "CastRipper_is1\";
nameRipper = registry_get_sz(key:key+item7, item:"Publisher");
if("Mini-stream" >< nameRipper)
{
  castripperVer = registry_get_sz(key:key+item7, item:"DisplayName");
  castripperVer = eregmatch(pattern:"CastRipper ([0-9.]+)", string:castripperVer);
  
  if(castripperVer[1] != NULL){
    set_kb_item(name:"MiniStream/CastRipper/Ver", value:castripperVer[1]);
  }
} 
