##############################################################################
#
#  GoodTech SSH Server SFTP Multiple BOF Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/24
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0392
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900166);
  script_bugtraq_id(31879);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"GoodTech SSH Server SFTP Multiple BOF Vulnerabilities");
  script_summary(english:"Check for vulnerable version of GoodTech SSH Server");
  desc["english"] = "
  Overview: The host is running GoodTech SSH server and is prone to multiple
  buffer overflow vulnerabilities.

  The flaws are caused due to error in SFTP 'open', 'opendir', and 'unlink'
  commands. This can be exploited by passing overly long string argument.

  Impact:
  Successful exploitation allows execution of arbitrary code, and denial of
  service.

  Impact Level: Application

  Affected Software/OS:
  GoodTech SSH Server version 6.4 and prior on Windows (all)

  Fix: No solution/patch is available as on 24th October, 2008.

  References:
  http://milw0rm.com/exploits/6804
  http://secunia.com/advisories/32375/
  http://www.frsirt.com/english/advisories/2008/2895

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 7.7
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl", "ssh_detect.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("smb_nt.inc");

sshPort = get_kb_item("Services/ssh");
if(!sshPort){
  sshPort = 22;
}

# check if FreeSSHd is listening
banner = get_kb_item("SSH/banner/" + sshPort);
if("SSH-2.0-cryptlib" >!< banner){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

sshVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                             "\Uninstall\GoodTech SSH Server",
                         item:"DisplayVersion");
if(sshVer){
  # Grep for SSH Server version 6.4 and prior
  if(egrep(pattern:"^([0-5](\..*)|6\.[0-4])$", string:sshVer)){
    security_warning(sshPort);
  }
}
