##############################################################################
#
#  CuteNews Version Detection for Windows
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/17
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0242
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900128);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"General");
 script_name(english:"CuteNews Version Detection for Windows");
 script_summary(english:"Set File Version of CuteNews in KB");
 desc["english"] = "
 Overview : This script find the CuteNews installed version of Windows and
 saves the version in KB.

 Risk factor : Informational";

 script_description(english:desc["english"]);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 foreach dir (make_list("/cutenews", cgi_dirs()))
 {
        sndReq = http_get(item:string(dir, "/index.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
                exit(0);
        }

        if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
        {
                cutenewsVer = egrep(pattern:"CuteNews v[0-9.]+", string:rcvRes);
                cutenewsVer = eregmatch(pattern:"[0-9.]+", string:cutenewsVer);
                if(cutenewsVer != NULL){
                        set_kb_item(name:"www/"+ port + "/CuteNews",
                                      value:cutenewsVer[0] + " under " + dir);
                }
        }
 }
