##############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_cubecart_detect.nasl 1093   2009-03-24 20:05:29Z Mar $
#
# Detection of cubecart Version
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900614);
  script_version("$Revision: 1.0 $");
  script_name(english:"Detecting the cubecart version");
  desc["english"] = "
  Overview:This script finds the version of the CubeCart installed
  on remote system and sets the equivelent value in the KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Detects the version of cubecart and sets the kb value");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_require_ports("Services/www", 80);
  script_dependencies("find_service.nes");
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/cubecart/upload","/upload", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:port);
  rcvRes =http_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }
  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) && ("CubeCart" >< rcvRes))
  {
    cubecartVer = egrep(pattern:"CubeCart</a> [0-9.]+", string:rcvRes);
    version = eregmatch(pattern:"> ([0-9.]+)", string:cubecartVer);
    if(version[1]!= NULL){
       set_kb_item(name:"www/"+ port + "/cubecart",value:version[1]);
    }
  }
}
