##############################################################################
#
#  ClamAV Invalid Memory Access Denial Of Service Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/05
#
#  Revision: 1.2
#
#  Log: ssharath
#  Issue #0164
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900117);
 script_bugtraq_id(30994);
 script_cve_id("CVE-2008-1389");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"ClamAV Invalid Memory Access Denial Of Service Vulnerability");
 script_summary(english:"Check for vulnerable version of ClamAV");
 desc["english"] = "
 Overview :  The host is running Clam AntiVirus, which is prone to denial of
 service vulnerability.
        
 Vulnerability Insight :
 
        The flaw exists due to an invalid memory access in chmunpack.c file,
        when processing a malformed CHM file.

        Impact: Successful remote exploitation will allow attackers to cause 
        the application to crash.

 Impact Level : Application
 
 Affected Software/OS :
        ClamAV versions prior to ClamAV 0.94 on all platform.

 Fix : Upgrade to ClamAV version 0.94
 http://www.clamav.net/download/sources
 
 References :
 http://www.frsirt.com/english/advisories/2008/2484
 http://svn.clamav.net/svn/clamav-devel/trunk/ChangeLog

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }
 
 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("clamav~" >< item)
        {
                if(egrep(pattern:"^clamav~0\.([0-8]?[0-9]|9[0-3])($|[^0-9])",
                         string:item))
		{
                        security_warning(0); 
		        exit(0);
                }
        }
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
        exit(0);
 }

 clamVer = ssh_cmd(socket:sock, cmd:"clamav-config --version", timeout:timeout);
 ssh_close_connection();

 if(!clamVer){
        exit(0);
 }

 if(egrep(pattern:"^0\.([0-8]?[0-9]|9[0-3])($|[^0-9])", string:clamVer)){
        security_warning(port);
 }
