# OpenVAS Vulnerability Test
# $Id$
# Description: This script ensure that a Firebase/Interbase database server is installed and running
#
# Firebird_Interbase_detect.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
# Slight modification by Vlatko Kosturjak - Kost <kost@linux.hr>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(80004);
name["english"] = "Firebase/Interbase database Server service detection";
script_name(english:name["english"]);
 
desc["english"] = "
The remote host is running the Firebase/Interbase database Server. 
Firebird is a RDBMS offering many ANSI SQL:2003 features. 
It runs on Linux, Windows, and a variety of Unix platforms 
and Started as a fork of Borland's open source release of InterBase


Solution :
It's recommended to allow connection to this host only from trusted hosts or networks,
or disable the service if not used.

Risk factor : None";

script_description(english:desc["english"]); 

summary["english"] = "Ensure that the remote host is running a Firebird/Interbase database server ";

script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);

script_copyright(english:"This script is Written by Christian Eric Edjenguele <christian.edjenguele@owasp.org> and released under GPL v2 or later");
family["english"] = "Service detection";
script_family(english:family["english"]);
script_dependencies("find_service.nes");
script_require_ports("Services/unknown", 3050);


exit(0);

}

#
# The script code starts here
#

include("misc_func.inc");

port = 3050;
soc_timeout = 10;
reponse = "";

# forge the firebird negociation protocol

firebird_auth_packet   = "0x000x000x000x010x000x000x000x130x000x000x000x020x00";
firebird_auth_packet += "0x000x000x240x000x000x000x1c0x2f0x6f0x700x74";
firebird_auth_packet += "0x2f0x660x690x720x650x620x690x720x640x2f0x62";
firebird_auth_packet += "0x690x6e0x2f0x6c0x650x670x690x6f0x6e0x2e0x66";
firebird_auth_packet += "0x640x620x000x000x000x020x000x000x000x170x01";
firebird_auth_packet += "0x040x720x6f0x6f0x740x040x090x630x680x720x69";
firebird_auth_packet += "0x730x740x690x610x6e0x050x040x000x000x000x00";
firebird_auth_packet += "0x000x000x000x000x080x000x000x000x010x000x00";
firebird_auth_packet += "0x000x020x000x000x000x030x000x000x000x020x00";
firebird_auth_packet += "0x000x000x0a0x000x000x000x010x000x000x000x02";
firebird_auth_packet += "0x000x000x000x030x000x000x000x04";
 

# Connect to remote Firebird/Interbase server
if(get_port_state(port)) soc = open_sock_tcp(port);
if(soc)
{
	send(socket:soc, data:firebird_auth_packet);
	response = recv(socket:soc, length:1024);

	close(soc);
}

if((!isnull(response)) && strlen(response == 16)) {
	register_service(port:port, ipproto:"tcp", proto:"gds_db");
	security_note(port);
}
