# OpenVAS Vulnerability Test
# $Id$
# Description: This script ensure that the Leap CMS is installed and running
#
# remote-detect-Leap_CMS.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(101025);
name["english"] = "Leap CMS service detection";
script_name(english:name["english"]);
 
desc["english"] = "
The remote host is running the Leap CMS. 
Leap is a single file, template independant, PHP and MySQL Content Management System.

Solution :
It's recommended to allow connection to this host only from trusted hosts or networks,
or disable the service if not used.

Risk factor : None";

script_description(english:desc["english"]); 

summary["english"] = "Detect a running Leap CMS";

script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);

script_copyright(english:"This script is Written by Christian Eric Edjenguele <christian.edjenguele@owasp.org> and released under GPL v2 or later");
family["english"] = "Service detection";
script_family(english:family["english"]);
script_dependencies("find_service.nes");
script_require_ports("Services/www", 80, 8080);


exit(0);

}

#
# The script code starts here
#

include("misc_func.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
report = '';

request = string("GET /leap/", " HTTP/1.1\r\n","Host: ", get_host_name(), "\r\n\r\n");

response = http_send_recv(port:port, data:request);


if(response){

	vendor = eregmatch(pattern:'Powered by <a href="http://leap.gowondesigns.com/">Leap</a> ([0-9.]+)',string:response, icase:TRUE);
	
	if(vendor){
		
		report += "\n Detected Leap CMS Version: " + vendor[1];
		set_kb_item(name:"LeapCMS/installed", value:TRUE);
		set_kb_item(name:"LeapCMS/port", value:port);
		set_kb_item(name:"LeapCMS/version", value:vendor[1]);

		server = eregmatch(pattern:"Server: ([a-zA-Z]+)/([0-9.]+)",string:response);

	        if(server){
		
	  	        set_kb_item(name:"LeapServer/type", value:server[1]);
		        set_kb_item(name:"LeapServer/version", value:server[2]);
		        report += " on " + server[0];
		        }
	}
}
if(report)
	security_note(port:port, data:report);
