# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:053 (squirrelmail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63445);
 script_cve_id("CVE-2008-3663");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:053 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory MDVSA-2009:053.

A vulnerability has been identified and corrected in squirrelmail:

Squirrelmail 1.4.15 does not set the secure flag for the session
cookie in an https session, which can cause the cookie to be sent in
http requests and make it easier for remote attackers to capture this
cookie (CVE-2008-3663).

Additionally many of the bundled plugins has been upgraded. The
localization has also been upgraded. Basically this is a syncronization
with the latest squirrelmail package found in Mandriva Cooker. The
rpm changelog will reveal all the changes (rpm -q --changelog
squirrelmail).

The updated packages have been upgraded to the latest version of
squirrelmail to prevent this.

Affected: Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:053

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:053 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"squirrelmail", rpm:"squirrelmail~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ar", rpm:"squirrelmail-ar~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-bg", rpm:"squirrelmail-bg~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-bn", rpm:"squirrelmail-bn~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ca", rpm:"squirrelmail-ca~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-cs", rpm:"squirrelmail-cs~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-cy", rpm:"squirrelmail-cy~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-cyrus", rpm:"squirrelmail-cyrus~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-da", rpm:"squirrelmail-da~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-de", rpm:"squirrelmail-de~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-el", rpm:"squirrelmail-el~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-en", rpm:"squirrelmail-en~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-es", rpm:"squirrelmail-es~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-et", rpm:"squirrelmail-et~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-eu", rpm:"squirrelmail-eu~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-fa", rpm:"squirrelmail-fa~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-fi", rpm:"squirrelmail-fi~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-fo", rpm:"squirrelmail-fo~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-fr", rpm:"squirrelmail-fr~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-fy", rpm:"squirrelmail-fy~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-he", rpm:"squirrelmail-he~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-hr", rpm:"squirrelmail-hr~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-hu", rpm:"squirrelmail-hu~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-id", rpm:"squirrelmail-id~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-is", rpm:"squirrelmail-is~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-it", rpm:"squirrelmail-it~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ja", rpm:"squirrelmail-ja~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ka", rpm:"squirrelmail-ka~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ko", rpm:"squirrelmail-ko~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-lt", rpm:"squirrelmail-lt~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ms", rpm:"squirrelmail-ms~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-nb", rpm:"squirrelmail-nb~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-nl", rpm:"squirrelmail-nl~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-nn", rpm:"squirrelmail-nn~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-pl", rpm:"squirrelmail-pl~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-poutils", rpm:"squirrelmail-poutils~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-pt", rpm:"squirrelmail-pt~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ro", rpm:"squirrelmail-ro~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ru", rpm:"squirrelmail-ru~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-sk", rpm:"squirrelmail-sk~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-sl", rpm:"squirrelmail-sl~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-sr", rpm:"squirrelmail-sr~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-sv", rpm:"squirrelmail-sv~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-th", rpm:"squirrelmail-th~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-tr", rpm:"squirrelmail-tr~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-ug", rpm:"squirrelmail-ug~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-uk", rpm:"squirrelmail-uk~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-vi", rpm:"squirrelmail-vi~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-zh_CN", rpm:"squirrelmail-zh_CN~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squirrelmail-zh_TW", rpm:"squirrelmail-zh_TW~1.4.17~0.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
