#
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
                                                                                
if(description)
{
 script_id(63692);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200903-37 (ghostscript-gpl ghostscript-esp ghostscript-gnu)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200903-37.

Multiple integer overflows in the Ghostscript ICC library might allow for
user-assisted execution of arbitrary code.

Solution:
All GPL Ghostscript users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/ghostscript-gpl-8.64-r2'

All GNU Ghostscript users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/ghostscript-gnu-8.62.0'

We recommend that users unmerge ESP Ghostscript and use GPL or GNU
Ghostscript instead:

    # emerge --unmerge 'app-text/ghostscript-esp'

For installation instructions, see above.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200903-37
http://bugs.gentoo.org/show_bug.cgi?id=261087

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200903-37 (ghostscript-gpl ghostscript-esp ghostscript-gnu)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/ghostscript-gpl", unaffected: make_list("ge 8.64-r2"), vulnerable: make_list("lt 8.64-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/ghostscript-gnu", unaffected: make_list("ge 8.62.0"), vulnerable: make_list("lt 8.62.0"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/ghostscript-esp", unaffected: make_list(), vulnerable: make_list("le 8.15.4-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
