# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(58698);
 script_cve_id("CVE-2007-1536", "CVE-2007-2799");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200710-19 (sleuthkit)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200710-19.

An integer underflow vulnerability has been reported in The Sleuth Kit
allowing for the user-assisted execution of arbitrary code.

Solution:
All The Sleuth Kit users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-forensics/sleuthkit-2.0.9'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200710-19
http://bugs.gentoo.org/show_bug.cgi?id=181977
http://www.gentoo.org/security/en/glsa/glsa-200703-26.xml
http://www.gentoo.org/security/en/glsa/glsa-200705-25.xml

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200710-19 (sleuthkit)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-forensics/sleuthkit", unaffected: make_list("ge 2.0.9"), vulnerable: make_list("lt 2.0.9"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
