# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54789);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200501-03 (Mozilla)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200501-03.

Various vulnerabilities were found and fixed in Mozilla-based products,
ranging from a potential buffer overflow and temporary files disclosure to
anti-spoofing issues.

Solution:
All Mozilla users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-www/mozilla-1.7.5'

All Mozilla binary users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-www/mozilla-bin-1.7.5'

All Firefox users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-www/mozilla-firefox-1.0'

All Firefox binary users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=net-www/mozilla-firefox-bin-1.0'

All Thunderbird users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose
'>=mail-client/mozilla-thunderbird-0.9'

All Thunderbird binary users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose
'>=mail-client/mozilla-thunderbird-bin-0.9'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200501-03
http://bugs.gentoo.org/show_bug.cgi?id=76112
http://bugs.gentoo.org/show_bug.cgi?id=68976
http://bugs.gentoo.org/show_bug.cgi?id=70749
http://isec.pl/vulnerabilities/isec-0020-mozilla.txt
http://broadcast.ptraced.net/advisories/008-firefox.thunderbird.txt
http://secunia.com/advisories/13144/

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200501-03 (Mozilla)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/mozilla", unaffected: make_list("ge 1.7.5"), vulnerable: make_list("lt 1.7.5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-bin", unaffected: make_list("ge 1.7.5"), vulnerable: make_list("lt 1.7.5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-firefox", unaffected: make_list("ge 1.0"), vulnerable: make_list("lt 1.0"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"net-www/mozilla-firefox-bin", unaffected: make_list("ge 1.0"), vulnerable: make_list("lt 1.0"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird", unaffected: make_list("ge 0.9"), vulnerable: make_list("lt 0.9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"mail-client/mozilla-thunderbird-bin", unaffected: make_list("ge 0.9"), vulnerable: make_list("lt 0.9"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
