# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54747);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200411-26 (GIMPS,SETI@home,ChessBrain)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200411-26.

Improper file ownership allows user-owned files to be run with root
privileges by init scripts.

Solution:
All GIMPS users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-sci/gimps-23.9-r1'

All SETI@home users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-sci/setiathome-3.03-r2'

All ChessBrain users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-sci/chessbrain-20407-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200411-26
http://bugs.gentoo.org/show_bug.cgi?id=69868

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200411-26 (GIMPS,SETI@home,ChessBrain)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-sci/gimps", unaffected: make_list("ge 23.9-r1"), vulnerable: make_list("le 23.9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-sci/setiathome", unaffected: make_list("ge 3.08-r4", "rge 3.03-r2"), vulnerable: make_list("le 3.08-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-sci/chessbrain", unaffected: make_list("ge 20407-r1"), vulnerable: make_list("le 20407"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
