# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54654);
 script_cve_id("CVE-2004-0415", "CVE-2004-0685");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200408-24 (Kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200408-24.

Multiple information leaks have been found in the Linux kernel, allowing an
attacker to obtain sensitive data which may be used for further
exploitation of the system.

Solution:
Users are encouraged to upgrade to the latest available sources for their
system:

    # emerge sync
    # emerge -pv your-favorite-sources
    # emerge your-favorite-sources

    # # Follow usual procedure for compiling and installing a kernel.
    # # If you use genkernel, run genkernel as you would normally.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200408-24
http://bugs.gentoo.org/show_bug.cgi?id=59378
http://bugs.gentoo.org/show_bug.cgi?id=59905
http://bugs.gentoo.org/show_bug.cgi?id=59769

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200408-24 (Kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"sys-kernel/aa-sources", unaffected: make_list("rge 2.4.23-r2", "ge 2.6.5-r5"), vulnerable: make_list("lt 2.6.5-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/alpha-sources", unaffected: make_list("ge 2.4.21-r12"), vulnerable: make_list("lt 2.4.21-r12"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ck-sources", unaffected: make_list("rge 2.4.26-r1", "ge 2.6.7-r5"), vulnerable: make_list("lt 2.6.7-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/development-sources", unaffected: make_list("ge 2.6.8"), vulnerable: make_list("lt 2.6.8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-dev-sources", unaffected: make_list("ge 2.6.7-r12"), vulnerable: make_list("lt 2.6.7-r12"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-sources", unaffected: make_list("rge 2.4.19-r22", "rge 2.4.20-r25", "rge 2.4.22-r16", "rge 2.4.25-r9", "ge 2.4.26-r9"), vulnerable: make_list("lt 2.4.26-r9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/grsec-sources", unaffected: make_list("ge 2.4.27.2.0.1-r1"), vulnerable: make_list("lt 2.4.27.2.0.1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gs-sources", unaffected: make_list("ge 2.4.25_pre7-r11"), vulnerable: make_list("lt 2.4.25_pre7-r11"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hardened-dev-sources", unaffected: make_list("ge 2.6.7-r7"), vulnerable: make_list("lt 2.6.7-r7"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hardened-sources", unaffected: make_list("ge 2.4.27-r1"), vulnerable: make_list("lt 2.4.27-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hppa-dev-sources", unaffected: make_list("ge 2.6.7_p14-r1"), vulnerable: make_list("lt 2.6.7_p14-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hppa-sources", unaffected: make_list("ge 2.4.26_p7-r1"), vulnerable: make_list("lt 2.4.26_p7-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ia64-sources", unaffected: make_list("ge 2.4.24-r10"), vulnerable: make_list("lt 2.4.24-r10"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/mips-sources", unaffected: make_list("rge 2.4.25-r8", "rge 2.4.26-r8", "rge 2.6.4-r8", "rge 2.6.6-r8", "ge 2.6.7-r5"), vulnerable: make_list("lt 2.6.6-r8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/mm-sources", unaffected: make_list("ge 2.6.8_rc4-r1"), vulnerable: make_list("lt 2.6.8_rc4-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/openmosix-sources", unaffected: make_list("ge 2.4.24-r4"), vulnerable: make_list("lt 2.4.24-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/pac-sources", unaffected: make_list("ge 2.4.23-r12"), vulnerable: make_list("lt 2.4.23-r12"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/pegasos-dev-sources", unaffected: make_list("ge 2.6.8"), vulnerable: make_list("lt 2.6.8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/rsbac-sources", unaffected: make_list("ge 2.4.26-r5"), vulnerable: make_list("lt 2.4.26-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/rsbac-dev-sources", unaffected: make_list("ge 2.6.7-r5"), vulnerable: make_list("lt 2.6.7-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/selinux-sources", unaffected: make_list("ge 2.4.26-r3"), vulnerable: make_list("lt 2.4.26-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/sparc-sources", unaffected: make_list("ge 2.4.27-r1"), vulnerable: make_list("lt 2.4.27-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/uclinux-sources", unaffected: make_list("rge 2.4.26_p0-r6", "ge 2.6.7_p0-r5"), vulnerable: make_list("lt 2.6.7_p0-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/usermode-sources", unaffected: make_list("rge 2.4.24-r9", "rge 2.4.26-r6", "ge 2.6.6-r6"), vulnerable: make_list("lt 2.6.6-r6"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vanilla-sources", unaffected: make_list("ge 2.4.27"), vulnerable: make_list("lt 2.4.27"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vserver-sources", unaffected: make_list("ge 2.4.26.1.28-r4"), vulnerable: make_list("lt 2.4.26.1.28-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/win4lin-sources", unaffected: make_list("rge 2.4.26-r6", "ge 2.6.7-r2"), vulnerable: make_list("lt 2.6.7-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/wolk-sources", unaffected: make_list("rge 4.9-r14", "rge 4.11-r10", "ge 4.14-r7"), vulnerable: make_list("lt 4.14-r7"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/xbox-sources", unaffected: make_list("rge 2.4.27-r1", "ge 2.6.7-r5"), vulnerable: make_list("lt 2.6.7-r5"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
