# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54527);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200403-02 (Kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200403-02.

A critical security vulnerability has been found in recent Linux kernels by
Paul Starzetz of iSEC Security Research which allows for local privilege
escalations.

Solution:
Users are encouraged to upgrade to the latest available sources for their
system:

    # emerge sync
    # emerge -pv your-favourite-sources
    # emerge your-favourite-sources
    # # Follow usual procedure for compiling and installing a kernel.
    # # If you use genkernel, run genkernel as you would do normally.
    
    # # IF YOUR KERNEL IS MARKED as 'remerge required!' THEN
    # # YOU SHOULD UPDATE YOUR KERNEL EVEN IF PORTAGE
    # # REPORTS THAT THE SAME VERSION IS INSTALLED.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200403-02
http://bugs.gentoo.org/show_bug.cgi?id=42024
http://isec.pl/vulnerabilities/isec-0014-mremap-unmap.txt

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200403-02 (Kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"sys-kernel/aa-sources", unaffected: make_list("ge 2.4.23-r1"), vulnerable: make_list("lt 2.4.23-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/alpha-sources", unaffected: make_list("ge 2.4.21-r4"), vulnerable: make_list("lt 2.4.21-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ck-sources", unaffected: make_list("eq 2.4.24-r1", "ge 2.6.2-r1"), vulnerable: make_list("lt 2.6.2-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/compaq-sources", unaffected: make_list("ge 2.4.9.32.7-r2"), vulnerable: make_list("lt 2.4.9.32.7-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/development-sources", unaffected: make_list("ge 2.6.3_rc1"), vulnerable: make_list("lt 2.6.3_rc1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gaming-sources", unaffected: make_list("ge 2.4.20-r8"), vulnerable: make_list("lt 2.4.20-r8"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-dev-sources", unaffected: make_list("ge 2.6.3_rc1"), vulnerable: make_list("lt 2.6.3_rc1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gentoo-sources", unaffected: make_list("eq 2.4.19-r11", "eq 2.4.20-r12", "ge 2.4.22-r7"), vulnerable: make_list("lt 2.4.22-r7"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/grsec-sources", unaffected: make_list("ge 2.4.24.1.9.13-r1"), vulnerable: make_list("lt 2.4.24.1.9.13-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/gs-sources", unaffected: make_list("ge 2.4.25_pre7-r2"), vulnerable: make_list("lt 2.4.25_pre7-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hardened-sources", unaffected: make_list("ge 2.4.24-r1"), vulnerable: make_list("lt 2.4.24-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hppa-dev-sources", unaffected: make_list("ge 2.6.2_p3-r1"), vulnerable: make_list("lt 2.6.2_p3-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/hppa-sources", unaffected: make_list("ge 2.4.24_p0-r1"), vulnerable: make_list("lt 2.4.24_p0-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ia64-sources", unaffected: make_list("ge 2.4.24-r1"), vulnerable: make_list("lt 2.4.24-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/mips-prepatch-sources", unaffected: make_list("ge 2.4.25_pre6-r1"), vulnerable: make_list("lt 2.4.25_pre6-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/mips-sources", unaffected: make_list("ge 2.4.25_rc4"), vulnerable: make_list("lt 2.4.25_rc4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/mm-sources", unaffected: make_list("ge 2.6.3_rc1-r1"), vulnerable: make_list("lt 2.6.3_rc1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/openmosix-sources", unaffected: make_list("ge 2.4.22-r4"), vulnerable: make_list("lt 2.4.22-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/pac-sources", unaffected: make_list("ge 2.4.23-r3"), vulnerable: make_list("lt 2.4.23-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/planet-ccrma-sources", unaffected: make_list("ge 2.4.21-r5"), vulnerable: make_list("lt 2.4.21-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ppc-development-sources", unaffected: make_list("ge 2.6.3_rc1-r1"), vulnerable: make_list("lt 2.6.3_rc1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ppc-sources", unaffected: make_list("ge 2.4.24-r1"), vulnerable: make_list("lt 2.4.24-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ppc-sources-benh", unaffected: make_list("ge 2.4.22-r5"), vulnerable: make_list("lt 2.4.22-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ppc-sources-crypto", unaffected: make_list("ge 2.4.20-r3"), vulnerable: make_list("lt 2.4.20-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/ppc-sources-dev", unaffected: make_list("ge 2.4.24-r2"), vulnerable: make_list("lt 2.4.24-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/selinux-sources", unaffected: make_list("ge 2.4.24-r2"), vulnerable: make_list("lt 2.4.24-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/sparc-dev-sources", unaffected: make_list("ge 2.6.3_rc1"), vulnerable: make_list("lt 2.6.3_rc1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/sparc-sources", unaffected: make_list("ge 2.4.24-r2"), vulnerable: make_list("lt 2.4.24-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/usermode-sources", unaffected: make_list("rge 2.4.24-r1", "rge 2.4.26", "ge 2.6.3-r1"), vulnerable: make_list("lt 2.6.3-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vanilla-prepatch-sources", unaffected: make_list("ge 2.4.25_rc4"), vulnerable: make_list("lt 2.4.25_rc4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/vanilla-sources", unaffected: make_list("ge 2.4.25"), vulnerable: make_list("lt 2.4.25"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/win4lin-sources", unaffected: make_list("eq 2.4.23-r2", "ge 2.6.2-r1"), vulnerable: make_list("lt 2.6.2-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/wolk-sources", unaffected: make_list("eq 4.9-r4", "ge 4.10_pre7-r3"), vulnerable: make_list("lt 4.10_pre7-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"sys-kernel/xfs-sources", unaffected: make_list("ge 2.4.24-r2"), vulnerable: make_list("lt 2.4.24-r2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
