###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpress_dir_trav_vuln.nasl 365 2008-11-4 10:10:24Z oct $
#
# WordPress cat Parameter Directory Traversal Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800124);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4769");
  script_bugtraq_id(28845);
  script_name(english:"WordPress cat Parameter Directory Traversal Vulnerability");
  desc["english"] = "

  Overview: The host is installed with WordPress and is prone to Directory Traversal
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of input passed via cat parameter
  to index.php which is not properly sanitized in the get_category_template()
  function.

  Impact: Successful attack could lead to execution of arbitrary PHP code and
  can even access sensitive information.

  Impact Level: Application

  Affected Software/OS:
  WordPress 2.3.3 and earlier.

  Fix: Update to Version 2.5.1 or later.
  http://wordpress.org/

  References:
  http://secunia.com/advisories/29949
  http://www.juniper.fi/security/auto/vulnerabilities/vuln28845.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/wordpress", cgi_dirs());
foreach dir (dirs)
{
  url = dir + "/index.php";
  sndReq = http_get(item:url, port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"Powered by WordPress", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    wdPressVer = eregmatch(pattern:"WordPress ([0-9.]+)", string:rcvRes);
    if(wdPressVer != NULL)
    {
      if(version_is_less_equal(version:wdPressVer[1], test_version:"2.3.3")){
        security_warning(port);
      }
    }
    exit(0);
  }
}
