###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for slocate vulnerability USN-425-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840175);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "425-1");
  script_cve_id("CVE-2007-0227");
  script_name(english: "Ubuntu Update for slocate vulnerability USN-425-1");
  desc["english"] = "

  Vulnerability Insight:

  A flaw was discovered in the permission checking code of slocate.  When
  reporting matching files, locate would not correctly respect the parent
  directory's &quot;read&quot; bits.  This could result in filenames being displayed
  when the file owner had expected them to remain hidden from other system
  users.

  Affected Software/OS:
  slocate vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000488.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of slocate vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"slocate", ver:"3.0.beta.r3-1ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"slocate", ver:"3.1-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}