###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_twiki_detect.nasl 2120 2009-05-06 15:37:24Z may $
#
# TWiki Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800399);
  script_version("Revision: 1.0");
  script_name(english:"TWiki Version Detection");
  desc["english"] = "

  Overview: This script detects the installed version of TWiki and
  sets the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of TWiki in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

twikiPort = get_http_port(default:80);
if(!twikiPort){
  twikiPort = 80;
}

if(!get_port_state(twikiPort)){
  exit(0);
}

foreach dir (make_list("/twiki", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/bin/view/TWiki/WebHome", port:twikiPort);
  rcvRes = http_send_recv(port:twikiPort, data:sndReq);

  if("Powered by TWiki" >< rcvRes )
  {
    twikiVer = eregmatch(pattern:"TWiki-([0-9.]+),", string:rcvRes);
    if(twikiVer[1] != NULL){
      set_kb_item(name:"www/" + twikiPort + "/TWiki", value:twikiVer[1] +
                       " under " + dir);
    }
  }
}
