###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for cups SUSE-SA:2008:020
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850017);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-020");
  script_cve_id("CVE-2008-0053", "CVE-2008-1373");
  script_name(english: "SuSE Update for cups SUSE-SA:2008:020");
  desc["english"] = "

  Vulnerability Insight:

  Two security issues were fixed in the CUPS printing system, which
  could be used by an attacker to crash CUPS or to potentially execute
  malicious code.

  - specially crafted GIF files could cause a buffer overflow in the
  printer filter for image files CVE-2008-1373.

  - specially crafted files could cause a buffer overflow in the HP-GL/2
  printer filter CVE-2008-0053.

  Impact:
  remote code execution

  Affected Software/OS:
  cups on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_20_cups.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.12~22.13", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.12~22.13", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.12~22.13", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.12~22.13", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.2.12~22.13", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.7~12.15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.7~12.15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.7~12.15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.7~12.15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.2.7~12.15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.41", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.41", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.41", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.41", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.41", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.20~108.50", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.20~108.50", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.20~108.50", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.20~108.50", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.41", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.41", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.41", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.41", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.1.23~40.41", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.23~40.41", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.1.23~40.41", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.23~40.41", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.23~40.41", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}