###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for ghostscript SUSE-SA:2008:010
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850050);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-010");
  script_cve_id("CVE-2008-0411");
  script_name(english: "SuSE Update for ghostscript SUSE-SA:2008:010");
  desc["english"] = "

  Vulnerability Insight:

  A stack based buffer overflow was fixed in the ghostscript interpreter,
  which can be used to execute code or at least crash ghostscript.
  CVE-2008-0411

  This can be exploited for instance by site local users printing to
  a print server which uses ghostscript to raster data, making this a
  remote problem.

  Unfortunately this error is not caught by the stack overflow protection
  technologies we use.

  Impact:
  remote code execution

  Affected Software/OS:
  ghostscript on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_10_ghostscript.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.4~3.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~178.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~178.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~26", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~103", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~103", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-serv", rpm:"ghostscript-serv~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~7.07.1rc1~195.11", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.6~46.10", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.6~46.10", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.3~18.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~62.13.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~62.14.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}