###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for acroread SUSE-SA:2008:009
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850034);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-009");
  script_cve_id("CVE-2008-0655", "CVE-2008-0667", "CVE-2008-0726");
  script_name(english: "SuSE Update for acroread SUSE-SA:2008:009");
  desc["english"] = "

  Vulnerability Insight:

  This version update to 8.1.2 fixes numerous bugs, including some
  security problems.

  While Adobe did not publish any details about those problems yet,
  third parties have listed some.

  The official Adobe page is:
  http://www.adobe.com/support/security/advisories/apsa08-01.html

  CVE-2008-0655: Multiple unspecified vulnerabilities in Adobe Reader
  and Acrobat before 8.1.2 have unknown impact and
  attack vectors.

  CVE-2008-0667: The DOC.print function in the Adobe JavaScript API,
  as used by Adobe Acrobat and Reader before 8.1.2, allows
  remote attackers to configure silent non-interactive
  printing, and trigger the printing of an arbitrary
  number of copies of a document.

  CVE-2008-0726: Integer overflow in Adobe Reader and Acrobat 8.1.1 and
  earlier allows remote attackers to execute arbitrary
  code via crafted arguments to the printSepsWithParams,
  which triggers memory corruption.

  Packages for SUSE Linux Enterprise Server 9 and Novell Linux Desktop
  9 are not yet available, since we cannot upgrade to Acrobat Reader 8
  on those machines. As soon as a fixed Acrobat Reader 7 is released,
  they will receive updates.

  Impact:
  remote code execution

  Affected Software/OS:
  acroread on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_09_acroread.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of acroread");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.2~1.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.2~1.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.2~1.4", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"acroread_ja", rpm:"acroread_ja~8.1.2~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.2~1.4", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}