###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for opera SUSE-SA:2008:001
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850004);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-001");
  script_cve_id("CVE-2007-6520", "CVE-2007-6521", "CVE-2007-6522", "CVE-2007-6523", "CVE-2007-6524");
  script_name(english: "SuSE Update for opera SUSE-SA:2008:001");
  desc["english"] = "

  Vulnerability Insight:

  Opera released version 9.25 of their browser to fix various security
  problems:

  CVE-2007-6520: Fixed an issue where plug-ins could be used to allow
  cross domain scripting, as reported by David Bloom. Details will be
  disclosed at a later date.

  CVE-2007-6521: Fixed an issue with TLS certificates that could
  be used to execute arbitrary code, as reported by Alexander Klink
  (Cynops GmbH). Details will be disclosed at a later date.

  CVE-2007-6522: Rich text editing can no longer be used to allow cross
  domain scripting, as reported by David Bloom. See our advisory.

  CVE-2007-6523: Fixed a problem where malformed BMP files could cause
  Opera to temporarily freeze.

  CVE-2007-6524: Prevented bitmaps from revealing random data from
  memory, as reported by Gynvael Coldwind. Details will be disclosed
  at a later date.

  Impact:
  remote code execution

  Affected Software/OS:
  opera on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/opera_9-25.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of opera");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.25~1.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.25~1.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.25~1.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}