###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for pcre SUSE-SA:2007:062
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850068);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-062");
  script_cve_id("CVE-2005-4872", "CVE-2006-7227", "CVE-2006-7228", "CVE-2006-7230", "CVE-2007-1659", "CVE-2007-1660", "CVE-2007-1661", "CVE-2007-4766", "CVE-2007-4767");
  script_name(english: "SuSE Update for pcre SUSE-SA:2007:062");
  desc["english"] = "

  Vulnerability Insight:

  Specially crafted regular expressions could lead to buffer overflows
  in the pcre library. Applications using pcre to process regular
  expressions from untrusted sources could therefore potentially be
  exploited by attackers to execute arbitrary code as the user running
  the application.

  Impact:
  remote code execution

  Affected Software/OS:
  pcre on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_62_pcre.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pcre");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~7.2~14.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~7.2~14.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-32bit", rpm:"pcre-32bit~7.2~14.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.7~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.7~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-32bit", rpm:"pcre-32bit~6.7~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~3.9~275", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-32bit", rpm:"pcre-32bit~6.4~14.12", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~4.4~109.10", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~4.4~109.10", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~4.4~109.10", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~4.4~109.10", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-32bit", rpm:"pcre-32bit~6.4~14.12", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~4.4~109.10", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~4.4~109.10", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-32bit", rpm:"pcre-32bit~6.4~14.12", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~6.4~14.12", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~6.4~14.12", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~4.4~109.10", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~4.4~109.10", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}