###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for file SUSE-SA:2007:040
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850080);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-040");
  script_cve_id("CVE-2007-1536", "CVE-2007-2799");
  script_name(english: "SuSE Update for file SUSE-SA:2007:040");
  desc["english"] = "

  Vulnerability Insight:

  A previous security fix for file introduced a new integer overflow
  in the file_printf() function and potentially be used to execute code.

  This has been fixed and updates have been provided.

  Since file can be run by automatic scripts, remote exploitation might
  be possible.

  This issue is tracked by the Mitre CVE ID CVE-2007-2799.

  Impact:
  potential code execution

  Affected Software/OS:
  file on SUSE LINUX 10.1, openSUSE 10.2, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_40_file.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of file");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.17~27", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.17~27", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-32bit", rpm:"file-32bit~4.17~27", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.16~15.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file", rpm:"file~4.16~15.13", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.09~3.7", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.09~3.7", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.09~3.7", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.16~15.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file", rpm:"file~4.16~15.13", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.09~3.7", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.16~15.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file", rpm:"file~4.16~15.13", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"file", rpm:"file~4.16~15.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"file-devel", rpm:"file-devel~4.16~15.13", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}