###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for mono-web SUSE-SA:2007:002
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850112);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-002");
  script_cve_id("CVE-2006-6104");
  script_name(english: "SuSE Update for mono-web SUSE-SA:2007:002");
  desc["english"] = "

  Vulnerability Insight:

  A security problem was found and fixed in the Mono / C# web server
  implementation.

  By appending spaces to URLs attackers could download the source code
  of ASP.net scripts that would normally get executed by the web server.

  This issue is tracked by the Mitre CVE ID CVE-2006-6104 and only
  affects SUSE Linux 10.1, openSUSE 10.2 and SUSE Linux Enterprise 10.

  Older products are not affected.

  The updated packages for this problem were released on December 29th 2006.

  Impact:
  remote source code disclosure

  Affected Software/OS:
  mono-web on openSUSE 10.2, SUSE LINUX 10.1, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_02_mono.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mono-web");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLED10")
{

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-basic", rpm:"mono-basic~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core-32bit", rpm:"mono-core-32bit~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.1.13.8~2.15", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core-32bit", rpm:"mono-core-32bit~1.1.18.1~12.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-basic", rpm:"mono-basic~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core-32bit", rpm:"mono-core-32bit~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.1.13.8~2.15", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-basic", rpm:"mono-basic~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.1.13.8~2.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}