###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ruby_rails_http_header_inj_vuln_lin.nasl 0521 2008-11-25 15:05:55Z nov $
#
# Ruby on Rails redirect_to() HTTP Header Injection Vulnerability - Linux
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800144);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5189");
  script_bugtraq_id(32359);
  script_name(english:"Ruby on Rails redirect_to() HTTP Header Injection Vulnerability - Linux");
  desc["english"] = "

  Overview: The host is running Ruby on Rails, which is prone to HTTP Header
  Injection Vulnerability.

  Vulnerability Insight:
  Input passed to the redirect_to() function is not properly sanitized before
  being used.

  Impact:
  Successful attack could lead to execution of arbitrary HTML or scripting code
  in the context of an affected application or allow Cross Site Request Forgery
  (CSRF), Cross Site Scripting (XSS) and HTTP Request Smuggling Attacks.

  Impact Level: Application

  Affected Software/OS:
  Ruby on Rails Version before 2.0.5 on Linux.

  Fix: Upgrade to higher Version or Apply patches from,
  http://github.com/rails/rails/commit/7282ed863ca7e6f928bae9162c9a63a98775a19d

  *****
  NOTE: Ignore this warning, if above mentioned patch is manually applied.
  *****

  References:
  http://weblog.rubyonrails.org/2008/10/19/response-splitting-risk
  http://www.rorsecurity.info/journal/2008/10/20/header-injection-and-response-splitting.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Ruby on Rails");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = 3000;

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

sndReq = string("GET /\r\n");
send(socket:soc, data:sndReq);
if("Ruby on Rails" >!< recv(socket:soc, length:1024))
{
  close(soc);
  exit(0);
}
close(soc);

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

railsFile = find_file(file_name:"rails", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach binFile (railsFile)
{
  railsVer = get_bin_version(full_prog_name:chomp(binFile), version_argv:"-v",
                             ver_pattern:"Rails ([0-9.]+)", sock:sock);
  if(railsVer[1] != NULL)
  {
    if(version_is_less(version:railsVer[1], test_version:"2.0.5")){
      security_warning(port);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
