###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_quagga_detect.nasl 2181 2009-05-07 19:39:29Z may $
#
# Quagga Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800709);
  script_version("$Revision: 1.0 $");
  script_name(english:"Quagga Version Detection");
  desc["english"] = "

  Overview: The script detects the version of Quagga for Linux on
  remote host and sets the result into KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Quagga version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Service detection");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

quaggaPaths = find_file(file_name:"watchquagga", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach quaggaBin (quaggaPaths)
{
  quaggaVer = get_bin_version(full_prog_name:chomp(quaggaBin), sock:sock,
                             version_argv:"-v",
                             ver_pattern:"version ([0-9.]+)");
  if(quaggaVer[1] != NULL)
  {
    set_kb_item(name:"Quagga/Ver", value:quaggaVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
