###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpwebgallery_mult_vuln_oct08.nasl 352 2008-10-20 16:16:24Z oct $
#
# Multiple XSS Vulnerabilities in PHPWebGallery - Oct08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800115);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4591", "CVE-2008-4702");
  script_name(english:"Multiple XSS Vulnerabilities in PHPWebGallery - Oct08");
  desc["english"] = "

  Overview: The host is running PHPWebGallery which is prone to multiple
  XSS and script inclusion Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to improper validation of input data to parameters
  in isadmin.inc.php and init.inc.php file, which allow remote attackers to
  inject arbitrary web script via lang[access_forbiden], lang[ident_title],
  user[language] and user[template] parameters.

  Impact:
  Successful attack could lead to execution of arbitrary HTML or scripting
  code in the security context of an affected web page.

  Impact Level: Application

  Affected Software/OS:
  PHPWebGallery Version 1.3.4 and prior on all running platform.

  Fix: No solution/patch is available as on 21st October, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://download.gna.org/phpwebgallery/

  References:
  http://www.milw0rm.com/exploits/6425

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of PHPWebGallery");
  script_category(ACT_MIXED_ATTACK);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses : XSS");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/phpwebgallery", cgi_dirs());
foreach dir (dirs)
{
  url = dir + "/category.php";
  sndReq = http_get(item:url, port:port);
  rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);

  if(rcvRes == NULL){
    exit(0);
  }

  if(rcvRes =~ "Powered by.+PhpWebGallery")
  {
    if(safe_checks())
    {
      rcvRes = eregmatch(pattern:"PhpWebGallery.+ ([0-9.]+)", string:rcvRes);
      if(rcvRes != NULL)
      {
        if(version_is_less_equal(version:rcvRes[1], test_version:"1.3.4")){
          security_hole(port);
        }
      }
      exit(0);
    }
    url = dir + "/admin/include/isadmin.inc.php?lang[access_forbiden]="+
                "<script>alert(document.cookie);</script>";
    sndReq = http_get(item:url, port:port);
    rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);
    if(rcvRes == NULL){
      exit(0);
    }

    if("<script>alert(document.cookie);</script>" >< rcvRes){
      security_hole(port);
    }
    exit(0);
  }
}
