###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_merak_mail_server_script_inj_vuln.nasl 790 2009-01-06 10:42:13Z jan $
#
# Merak Mail Server Web Mail IMG HTML Tag Script Insertion Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800097);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5734");
  script_name(english:"Merak Mail Server Web Mail IMG HTML Tag Script Insertion Vulnerability");
  desc["english"] = "

  Overview: The host is running Merak Mail Server and is prone to script
  injection vulnerability.

  Vulnerability:
  Input passed via <IMG> HTML tags in emails are not properly sanitised before
  being displayed in the users system.

  Impact:
  Successful exploitation could result in insertion of arbitrary HTML and
  script code via a specially crafted email in a user's browser session in
  the context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Merak Mail Server 9.3.2 and prior.

  Fix: Upgrade to Merak Mail Server 9.4.0
  http://www.icewarp.com

  References:
  http://osvdb.org/50885
  http://secunia.com/advisories/32770
  http://xforce.iss.net/xforce/xfdb/47533
  http://blog.vijatov.com/index.php?itemid=11

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Merak Mail Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_merak_mail_server_detect.nasl");
  script_require_keys("MerakMailServer/Ver");
  exit(0);
}


include("version_func.inc");

merakVer = get_kb_item("MerakMailServer/Ver");
if(!merakVer){
  exit(0);
}

if(version_is_less(version:merakVer, test_version:"9.4.0")){
  security_warning(0);
}
