###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for hplip MDVSA-2008:169 (hplip)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830645);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:169");
  script_cve_id("CVE-2008-2940", "CVE-2008-2941");
  script_name(english: "Mandriva Update for hplip MDVSA-2008:169 (hplip)");
  desc["english"] = "

  Vulnerability Insight:

  Marc Schoenefeld of the Red Hat Security Response Team discovered a
  vulnerability in the hplip alert-mailing functionality that could allow
  a local attacker to elevate their privileges by using specially-crafted
  packets to trigger alert mails that are sent by the root account
  (CVE-2008-2940).
  
  Another vulnerability was discovered by Marc Schoenefeld in the hpssd
  message parser that could allow a local attacker to stop the hpssd
  process by sending specially-craftd packets, causing a denial of
  service (CVE-2008-2941).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  hplip on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00012.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of hplip");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~2.7.7~7.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~2.7.7~8.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~2.8.2~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}