###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ImageMagick MDVSA-2008:035 (ImageMagick)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830377);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:035");
  script_cve_id("CVE-2007-4985", "CVE-2007-4986", "CVE-2007-4987", "CVE-2007-4988");
  script_name(english: "Mandriva Update for ImageMagick MDVSA-2008:035 (ImageMagick)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple vulnerabilities were discovered in the image decoders
  of ImageMagick.  If a user or automated system were tricked into
  processing malicious DCM, DIB, XBM, XCF, or XWD images, a remote
  attacker could execute arbitrary code with user privileges.
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  ImageMagick on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-desktop", rpm:"ImageMagick-desktop~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-doc", rpm:"ImageMagick-doc~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.7.0", rpm:"libMagick10.7.0~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.7.0-devel", rpm:"libMagick10.7.0-devel~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Image-Magick", rpm:"perl-Image-Magick~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.7.0", rpm:"lib64Magick10.7.0~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.7.0-devel", rpm:"lib64Magick10.7.0-devel~6.3.2.9~5.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-doc", rpm:"ImageMagick-doc~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.4.0", rpm:"libMagick10.4.0~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libMagick10.4.0-devel", rpm:"libMagick10.4.0-devel~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Image-Magick", rpm:"perl-Image-Magick~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.4.0", rpm:"lib64Magick10.4.0~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64Magick10.4.0-devel", rpm:"lib64Magick10.4.0-devel~6.2.9.2~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"imagemagick", rpm:"imagemagick~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imagemagick-desktop", rpm:"imagemagick-desktop~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"imagemagick-doc", rpm:"imagemagick-doc~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagick10.7.0", rpm:"libmagick10.7.0~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmagick10.7.0-devel", rpm:"libmagick10.7.0-devel~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"perl-Image-Magick", rpm:"perl-Image-Magick~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magick10.7.0", rpm:"lib64magick10.7.0~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64magick10.7.0-devel", rpm:"lib64magick10.7.0-devel~6.3.2.9~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}