###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for icu MDVSA-2008:026 (icu)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830687);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:026");
  script_cve_id("CVE-2007-4770", "CVE-2007-4771");
  script_name(english: "Mandriva Update for icu MDVSA-2008:026 (icu)");
  desc["english"] = "

  Vulnerability Insight:

  Will Drewry reported multiple flaws in how libicu processed certain
  malformed regular expressions.  If an application linked against
  libicu, such as OpenOffice.org, processed a carefully-crafted regular
  expression, it could potentially cause the execution of arbitrary
  code with the privileges of the user running the application.
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  icu on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00045.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of icu");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"icu", rpm:"icu~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"icu-doc", rpm:"icu-doc~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libicu-devel", rpm:"libicu-devel~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libicu36", rpm:"libicu36~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64icu-devel", rpm:"lib64icu-devel~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64icu36", rpm:"lib64icu36~3.6~4.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}