###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for madwifi-source MDVSA-2008:007 (madwifi-source)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830524);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:007");
  script_cve_id("CVE-2007-5448");
  script_name(english: "Mandriva Update for madwifi-source MDVSA-2008:007 (madwifi-source)");
  desc["english"] = "

  Vulnerability Insight:

  MadWifi prior to 0.9.3.3 allowed remote attackers to cause a denial
  of service (panic) via a beacon frame with a large length value in
  the extended supported rates (xrates) element, which would trigger
  an assertion error.
  
  Updated packages have been updated to 0.9.3.3 to correct this
  issue. Wpa_supplicant is built using madwifi-source and has been
  rebuilt using 0.9.3.3 source.

  Affected Software/OS:
  madwifi-source on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of madwifi-source");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3.3~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.7~1.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.7~1.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.5~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.5~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3.3~1.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.6.0~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.6.0~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}