###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for postgresql MDVSA-2008:004 (postgresql)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830498);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:004");
  script_cve_id("CVE-2007-6600", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-4769", "CVE-2007-6601", "CVE-2007-3278");
  script_name(english: "Mandriva Update for postgresql MDVSA-2008:004 (postgresql)");
  desc["english"] = "

  Vulnerability Insight:

  Index Functions Privilege Escalation (CVE-2007-6600): as a unique
  feature, PostgreSQL allows users to create indexes on the results of
  user-defined functions, known as expression indexes. This provided
  two vulnerabilities to privilege escalation: (1) index functions were
  executed as the superuser and not the table owner during VACUUM and
  ANALYZE, and (2) that SET ROLE and SET SESSION AUTHORIZATION were
  permitted within index functions.
  
  Regular Expression Denial-of-Service (CVE-2007-4772, CVE-2007-6067,
  CVE-2007-4769): three separate issues in the regular expression
  libraries used by PostgreSQL allowed malicious users to initiate
  a denial-of-service by passing certain regular expressions in SQL
  queries. First, users could create infinite loops using some specific
  regular expressions. Second, certain complex regular expressions
  could consume excessive amounts of memory. Third, out-of-range backref
  numbers could be used to crash the backend.
  
  DBLink Privilege Escalation (CVE-2007-6601): DBLink functions
  combined with local trust or ident authentication could be used by
  a malicious user to gain superuser privileges. This issue has been
  fixed, and does not affect users who have not installed DBLink (an
  optional module), or who are using password authentication for local
  access. This same problem was addressed in the previous release cycle
  (see CVE-2007-3278), but that patch failed to close all forms of
  the loophole.
  
  Updated packages fix these issues by upgrading to the latest
  maintenance versions of PostgreSQL.

  Affected Software/OS:
  postgresql on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq5", rpm:"libpq5~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq5-devel", rpm:"libpq5-devel~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq5", rpm:"lib64pq5~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq5-devel", rpm:"lib64pq5-devel~8.2.6~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4", rpm:"libpq4~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4-devel", rpm:"libpq4-devel~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4", rpm:"lib64pq4~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4-devel", rpm:"lib64pq4-devel~8.1.11~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libecpg-devel", rpm:"libecpg-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq-devel", rpm:"libpq-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq5", rpm:"libpq5~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2", rpm:"postgresql8.2~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-contrib", rpm:"postgresql8.2-contrib~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-devel", rpm:"postgresql8.2-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-docs", rpm:"postgresql8.2-docs~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-pl", rpm:"postgresql8.2-pl~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-plperl", rpm:"postgresql8.2-plperl~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-plpgsql", rpm:"postgresql8.2-plpgsql~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-plpython", rpm:"postgresql8.2-plpython~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-pltcl", rpm:"postgresql8.2-pltcl~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-server", rpm:"postgresql8.2-server~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql8.2-test", rpm:"postgresql8.2-test~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg-devel", rpm:"lib64ecpg-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq-devel", rpm:"lib64pq-devel~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq5", rpm:"lib64pq5~8.2.6~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}