###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for apache MDKSA-2007:235 (apache)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830196);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:235");
  script_cve_id("CVE-2007-3847", "CVE-2007-4465");
  script_name(english: "Mandriva Update for apache MDKSA-2007:235 (apache)");
  desc["english"] = "

  Vulnerability Insight:

  A flaw in the Apache mod_proxy module was found that could potentially
  lead to a denial of service is using a threaded Multi-Processing
  Module.  On sites where a reverse proxy is configured, a remote
  attacker could send a special reequest that would cause the Apache
  child process handling the request to crash.  Likewise, a similar crash
  could occur on sites with a forward proxy configured if a user could
  be persuaded to visit a malicious site using the proxy (CVE-2007-3847).
  
  A flaw in the Apache mod_autoindex module was found.  On sites where
  directory listings are used and the AddDefaultCharset directive was
  removed from the configuration, a cross-site-scripting attack could
  be possible against browsers that to not correctly derive the response
  character set according to the rules in RGC 2616 (CVE-2007-4465).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  apache on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-12/msg00002.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"apache-base", rpm:"apache-base~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-htcacheclean", rpm:"apache-htcacheclean~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_authn_dbd", rpm:"apache-mod_authn_dbd~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_cache", rpm:"apache-mod_cache~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_dav", rpm:"apache-mod_dav~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_dbd", rpm:"apache-mod_dbd~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_deflate", rpm:"apache-mod_deflate~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_disk_cache", rpm:"apache-mod_disk_cache~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_file_cache", rpm:"apache-mod_file_cache~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_ldap", rpm:"apache-mod_ldap~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_mem_cache", rpm:"apache-mod_mem_cache~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_proxy", rpm:"apache-mod_proxy~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_proxy_ajp", rpm:"apache-mod_proxy_ajp~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_ssl", rpm:"apache-mod_ssl~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_userdir", rpm:"apache-mod_userdir~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-modules", rpm:"apache-modules~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-event", rpm:"apache-mpm-event~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-itk", rpm:"apache-mpm-itk~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-prefork", rpm:"apache-mpm-prefork~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-worker", rpm:"apache-mpm-worker~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-source", rpm:"apache-source~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache", rpm:"apache~2.2.4~6.3mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"apache-base", rpm:"apache-base~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-htcacheclean", rpm:"apache-htcacheclean~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_authn_dbd", rpm:"apache-mod_authn_dbd~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_cache", rpm:"apache-mod_cache~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_dav", rpm:"apache-mod_dav~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_dbd", rpm:"apache-mod_dbd~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_deflate", rpm:"apache-mod_deflate~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_disk_cache", rpm:"apache-mod_disk_cache~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_file_cache", rpm:"apache-mod_file_cache~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_ldap", rpm:"apache-mod_ldap~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_mem_cache", rpm:"apache-mod_mem_cache~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_proxy", rpm:"apache-mod_proxy~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_proxy_ajp", rpm:"apache-mod_proxy_ajp~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_ssl", rpm:"apache-mod_ssl~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mod_userdir", rpm:"apache-mod_userdir~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-modules", rpm:"apache-modules~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-prefork", rpm:"apache-mpm-prefork~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-mpm-worker", rpm:"apache-mpm-worker~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-source", rpm:"apache-source~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache", rpm:"apache~2.2.3~1.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}