###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for hplip MDKSA-2007:201 (hplip)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830102);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:201");
  script_cve_id("CVE-2007-5208");
  script_name(english: "Mandriva Update for hplip MDKSA-2007:201 (hplip)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability in the hpssd tool was discovered where it did not
  correctly handle shell meta-characters.  A local attacker could use
  this flaw to execute arbitrary commands as the hplip user.
  
  As well, this update fixes a problem with some HP scanners on Mandriva
  Linux 2007.1, particularly HP PSC 1315, which wouldn't be detected
  and also fixes a problem with HP 1220 and possibly other models when
  scanning via the OpenOffice.org suite.
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  hplip on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-10/msg00013.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of hplip");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~2.7.7~7.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~1.6.9~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-doc", rpm:"hplip-doc~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs", rpm:"hplip-hpijs~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-hpijs-ppds", rpm:"hplip-hpijs-ppds~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-model-data", rpm:"hplip-model-data~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0", rpm:"libhpip0~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libhpip0-devel", rpm:"libhpip0-devel~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio1", rpm:"libsane-hpaio1~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0", rpm:"lib64hpip0~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64hpip0-devel", rpm:"lib64hpip0-devel~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64sane-hpaio1", rpm:"lib64sane-hpaio1~2.7.7~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}