###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for t1lib MDKSA-2007:189 (t1lib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830216);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:189");
  script_cve_id("CVE-2007-4033");
  script_name(english: "Mandriva Update for t1lib MDKSA-2007:189 (t1lib)");
  desc["english"] = "

  Vulnerability Insight:

  A buffer overflow vulnerability was discovered in t1lib due to improper
  bounds checking.  An attacker could send specially crafted input to
  an application linked against t1lib which could lead to a denial of
  service or the execution of arbitrary code.
  
  Updated packages have been patched to prevent this issue.

  Affected Software/OS:
  t1lib on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00020.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of t1lib");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libt1lib5", rpm:"libt1lib5~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libt1lib5-devel", rpm:"libt1lib5-devel~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libt1lib5-static-devel", rpm:"libt1lib5-static-devel~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib-config", rpm:"t1lib-config~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib-progs", rpm:"t1lib-progs~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib", rpm:"t1lib~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5", rpm:"lib64t1lib5~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5-devel", rpm:"lib64t1lib5-devel~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5-static-devel", rpm:"lib64t1lib5-static-devel~5.1.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libt1lib5", rpm:"libt1lib5~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libt1lib5-devel", rpm:"libt1lib5-devel~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libt1lib5-static-devel", rpm:"libt1lib5-static-devel~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib-config", rpm:"t1lib-config~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib-progs", rpm:"t1lib-progs~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"t1lib", rpm:"t1lib~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5", rpm:"lib64t1lib5~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5-devel", rpm:"lib64t1lib5-devel~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64t1lib5-static-devel", rpm:"lib64t1lib5-static-devel~5.1.0~3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}