###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for tetex MDKSA-2007:109 (tetex)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830125);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:109");
  script_cve_id("CVE-2007-0455", "CVE-2007-0650");
  script_name(english: "Mandriva Update for tetex MDKSA-2007:109 (tetex)");
  desc["english"] = "

  Vulnerability Insight:

  Buffer overflow in the gdImageStringFTEx function in gdft.c in the
  GD Graphics Library 2.0.33 and earlier allows remote attackers to
  cause a denial of service (application crash) and possibly execute
  arbitrary code via a crafted string with a JIS encoded font.
  
  Tetex 3.x uses an embedded copy of the gd source and may also be
  affected by this issue (CVE-2007-0455).
  
  A buffer overflow in the open_sty function for makeindex in Tetex
  could allow user-assisted remote attackers to overwrite files and
  possibly execute arbitrary code via a long filename (CVE-2007-0650).
  
  The updated packages have been patched to prevent these issues.

  Affected Software/OS:
  tetex on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00033.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tetex");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"jadetex", rpm:"jadetex~3.12~129.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-context", rpm:"tetex-context~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-devel", rpm:"tetex-devel~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvilj", rpm:"tetex-dvilj~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvipdfm", rpm:"tetex-dvipdfm~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-mfwin", rpm:"tetex-mfwin~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-texi2html", rpm:"tetex-texi2html~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-usrlocal", rpm:"tetex-usrlocal~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~31.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmltex", rpm:"xmltex~1.9~77.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"jadetex", rpm:"jadetex~3.12~116.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-context", rpm:"tetex-context~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-devel", rpm:"tetex-devel~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvilj", rpm:"tetex-dvilj~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvipdfm", rpm:"tetex-dvipdfm~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-mfwin", rpm:"tetex-mfwin~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-texi2html", rpm:"tetex-texi2html~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~18.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xmltex", rpm:"xmltex~1.9~64.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}