###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for ktorrent MDKSA-2007:095 (ktorrent)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830222);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:095");
  script_cve_id("CVE-2007-1799");
  script_name(english: "Mandriva Update for ktorrent MDKSA-2007:095 (ktorrent)");
  desc["english"] = "

  Vulnerability Insight:

  A directory traversal vulnerability was found in KTorrent prior to
  2.1.2, due to an incomplete fix for a prior directory traversal
  vulnerability that was corrected in version 2.1.2.  Previously,
  KTorrent would only check for the string .., which could permit
  strings such as ../.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  ktorrent on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00001.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ktorrent");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"ktorrent", rpm:"ktorrent~2.1.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libktorrent2.1.2", rpm:"libktorrent2.1.2~2.1.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ktorrent2.1.2", rpm:"lib64ktorrent2.1.2~2.1.2~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}