###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for madwifi-source MDKSA-2007:082 (madwifi-source)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830060);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:082");
  script_cve_id("CVE-2005-4835", "CVE-2006-7177", "CVE-2006-7178", "CVE-2006-7179", "CVE-2006-7180");
  script_name(english: "Mandriva Update for madwifi-source MDKSA-2007:082 (madwifi-source)");
  desc["english"] = "

  Vulnerability Insight:

  The ath_rate_sample function in the ath_rate/sample/sample.c sample
  code in MadWifi before 0.9.3 allows remote attackers to cause a denial
  of service (failed KASSERT and system crash) by moving a connected
  system to a location with low signal strength, and possibly other
  vectors related to a race condition between interface enabling and
  packet transmission. (CVE-2005-4835)
  
  MadWifi, when Ad-Hoc mode is used, allows remote attackers to cause
  a denial of service (system crash) via unspecified vectors that lead
  to a kernel panic in the ieee80211_input function, related to packets
  coming from a malicious WinXP system. (CVE-2006-7177)
  
  MadWifi before 0.9.3 does not properly handle reception of an AUTH
  frame by an IBSS node, which allows remote attackers to cause a denial
  of service (system crash) via a certain AUTH frame. (CVE-2006-7178)
  
  ieee80211_input.c in MadWifi before 0.9.3 does not properly process
  Channel Switch Announcement Information Elements (CSA IEs), which
  allows remote attackers to cause a denial of service (loss of
  communication) via a Channel Switch Count less than or equal to one,
  triggering a channel change. (CVE-2006-7179)
  
  ieee80211_output.c in MadWifi before 0.9.3 sends unencrypted packets
  before WPA authentication succeeds, which allows remote attackers
  to obtain sensitive information (related to network structure),
  and possibly cause a denial of service (disrupted authentication)
  and conduct spoofing attacks. (CVE-2006-7180)
  
  Updated packages have been updated to 0.9.3 to correct this
  issue. Wpa_supplicant is built using madwifi-source and has been
  rebuilt using 0.9.3 source.

  Affected Software/OS:
  madwifi-source on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00017.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of madwifi-source");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.7~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.7~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.5~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.5~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}